//	treedlg.cpp  -  catalog tree display sample code
//
//	This is a part of the MetaKit library.
//	Copyright (c) 1996 Meta Four Software.
//	All rights reserved.
/////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "catrecv.h"
#include "TreeDlg.h"

#ifdef _DEBUG
//#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// These are the properties used in the directory catalog

	static c4_ViewProp		pDirs ("dirs"),
							pFiles ("files");
	static c4_IntProp		pParent ("parent"),
							pSize ("size"),
							pDate ("date");
	static c4_StringProp	pName ("name");

/////////////////////////////////////////////////////////////////////////////
// CTreeDialog dialog

CTreeDialog::CTreeDialog (CFile& file_)
{
	_storage.LoadFromStream(&file_);	// load the data
	_dirs = pDirs (_storage.Contents());

	//{{AFX_DATA_INIT(CTreeDialog)
	//}}AFX_DATA_INIT

	Create(CTreeDialog::IDD);			// modeless stuff
}

void CTreeDialog::OnCancel()
{
	DestroyWindow();					// modeless stuff
}

void CTreeDialog::PostNcDestroy()
{
	CDialog::PostNcDestroy();			// modeless stuff
	delete this;
}

void CTreeDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CTreeDialog)
	DDX_Control(pDX, IDC_FILE_LIST, m_fileList);
	DDX_Control(pDX, IDC_DIR_TREE, m_dirTree);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CTreeDialog, CDialog)
	//{{AFX_MSG_MAP(CTreeDialog)
	ON_WM_SIZE()
	ON_NOTIFY(TVN_SELCHANGED, IDC_DIR_TREE, OnSelchangedDirTree)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// [JCW,960119]  This code added for MetaKit CATRECV

BOOL CTreeDialog::OnInitDialog() 
{
	CDialog::OnInitDialog();

		// find out how wide the '0' character is in pixels
	CDC* pDC = GetDC();
	ASSERT(pDC);
	int w = pDC->GetOutputTextExtent("0").cx;
	ReleaseDC(pDC);

		// set up three columns with reasonable starting widths
	VERIFY(m_fileList.InsertColumn(0, "Name", LVCFMT_LEFT, 12 * w) == 0);
	VERIFY(m_fileList.InsertColumn(1, "Size", LVCFMT_RIGHT, 7 * w, 1) == 1);
	VERIFY(m_fileList.InsertColumn(2, "Date", LVCFMT_LEFT, 6 * w, 2) == 2);
  
	RecalcLayout();

		// display the catalog contents
	if (_dirs.GetSize() > 0)
	{
		CString path = pName (_dirs[0]);
		SetWindowText("CATRECV - " + path);

		SetupDirTree();
	}

	return TRUE;  // return TRUE unless you set the focus to a control
}

// track changes in the main window size
void CTreeDialog::OnSize(UINT nType, int cx, int cy) 
{
	CDialog::OnSize(nType, cx, cy);
	
	if (m_dirTree.m_hWnd && m_fileList.m_hWnd)
		RecalcLayout();
}

// share the client area between the tree control and the list control
void CTreeDialog::RecalcLayout()
{
	CRect rect;
	GetClientRect(&rect);
	
	ASSERT(rect.left == 0 && rect.top == 0);
	int cx = rect.right;
	int cy = rect.bottom;

	m_dirTree.MoveWindow(0, 0, cx/2, cy);
	m_fileList.MoveWindow(cx/2, 0, cx - cx/2, cy); // careful with roundoff
}

// Initialize the contents of the tree control with the directory structure
// in the catalog that was just received. This version stores a copy of all
// directory names in the tree control, could be optimized to use a callback
// function to grab the name from the catalog whenever the control needs it.
void CTreeDialog::SetupDirTree()
{
	HTREEITEM root, parent, item;

		// the root needs to be treated a little differently
	root = m_dirTree.InsertItem(TVIF_TEXT | TVIF_PARAM, "(root)",
										0, 0, 0, 0, 0, 0, TVI_SORT);

		// remember all tree control item handles, one per directory
	_treeHandles.SetAtGrow(0, root);

		// now enter all remaining directories in the tree control
	for (int i = 1; i < _dirs.GetSize(); ++i)
	{
		c4_RowRef thisDir = _dirs[i];

			// extract the relevant information from the catalog
		CString dirName = pName (thisDir);
		parent = (HTREEITEM) _treeHandles[pParent (thisDir)];

			// insert an item in the tree and remember its handle
		item = m_dirTree.InsertItem(TVIF_TEXT | TVIF_PARAM, dirName,
										0, 0, 0, 0, i, parent, TVI_SORT);
		_treeHandles.SetAtGrow(i, item);
	}

		// start off with a tree with an expanded root level
	m_dirTree.Expand(root, TVE_EXPAND);

		// simulate a selection change (args are not really used here)
	OnSelchangedDirTree(0, 0);
}

// Update the file list when the directory selection changes. Again, a copy
// of all strings is stored in the list control instead of using callbacks.
void CTreeDialog::OnSelchangedDirTree(NMHDR* /* pNMHDR */, LRESULT* pResult) 
{
	VERIFY(m_fileList.DeleteAllItems());

	HTREEITEM item = m_dirTree.GetSelectedItem();
	if (item)
	{
			// locate the corresponding list of files in the catalog
		int dirIndex = m_dirTree.GetItemData(item);
		c4_View files = pFiles (_dirs[dirIndex]);
		
		for (int i = 0; i < files.GetSize(); ++i)
		{
				// extract the information from the catalog
			CString name = pName (files[i]);
			long size = pSize (files[i]);
			long date = pDate (files[i]);

				// create the main file entry
			int n = m_fileList.InsertItem(i, name);
			VERIFY(n >= 0);

			char buf [15];

				// set subitem 1 to the file size
			wsprintf(buf, "%ld", size);
			m_fileList.SetItemText(n, 1, buf);

				// set subitem 2 to the file date
			if (date)
			{
				wsprintf(buf, "%02d%02d%02d", 80 + (date >> 9),
										(date >> 5) & 0x0F, date & 0x1F);
				m_fileList.SetItemText(n, 2, buf);
			}
		}
	}
	
	if (pResult) // careful, this is null when called from SetupDirTree
		*pResult = 0;
}

/////////////////////////////////////////////////////////////////////////////
